﻿//If the SDK namespace object is not defined, create it.
if (typeof (MCS) == "undefined")
{ MCS = {}; }
// Create Namespace container for functions in this library;
MCS.cvt_MTSA_OnLoad = {};

//Page space variables
MCS.cvt_MTSA_OnLoad.EntityId = null;
MCS.cvt_MTSA_OnLoad.EntityName = null;
MCS.cvt_MTSA_OnLoad.relatedProviderSiteName = null;
MCS.cvt_MTSA_OnLoad.relatedProviderSiteId = null;
MCS.cvt_MTSA_OnLoad.GroupAppt = false;

//OnLoad
MCS.cvt_MTSA_OnLoad.SetDefaults = function () {
    Xrm.Page.getControl("cvt_type").setDisabled(false);

    //If not Create
    if (Xrm.Page.ui.getFormType() != MCS.cvt_Common.FORM_TYPE_CREATE) {
        //Read Only Fields
        Xrm.Page.getControl("cvt_relatedsiteid").setDisabled(true);
        Xrm.Page.getControl("cvt_servicetype").setDisabled(true);
        Xrm.Page.getControl("cvt_servicesubtype").setDisabled(true);
        Xrm.Page.getControl("cvt_groupappointment").setDisabled(true);
        Xrm.Page.getControl("cvt_availabletelehealthmodalities").setDisabled(true);
        Xrm.Page.getControl("cvt_type").setDisabled(true);
        //Conditional because of potentially missing data.
        if (Xrm.Page.getAttribute("cvt_providerlocationtype").getValue() != null) {
            Xrm.Page.getControl("cvt_providerlocationtype").setDisabled(true);
        }
        else {
            Xrm.Page.getControl("cvt_providerlocationtype").setDisabled(false);
        }

        MCS.cvt_MTSA_OnLoad.SOS();

        //Load Operations Guide
        var filter = "mcs_name eq 'Active Settings'";
        calls = CrmRestKit.ByQuery("mcs_setting", ['cvt_telehealthoperationsmanual'], filter, false);
        calls.fail(function (err) {
        }).done(function (data) {
            if (data && data.d && data.d.results != null && data.d.results.length != 0) {
                var url = data.d.results[0].cvt_telehealthoperationsmanual != null ? data.d.results[0].cvt_telehealthoperationsmanual : null;
                if (url != null)
                    Xrm.Page.getAttribute("cvt_telehealthoperationsmanual").setValue(url);
            }
        });
    }
    //Field manipulation - These are all called by specific field OnChange
    if (Xrm.Page.getAttribute("cvt_servicesubtype").getValue() != null)
        MCS.cvt_Common.EnableDependentLookup("cvt_servicetype", "cvt_servicesubtype");

    MCS.cvt_MTSA_OnLoad.EntityId = Xrm.Page.data.entity.getId();
    MCS.cvt_MTSA_OnLoad.EntityName = Xrm.Page.data.entity.getEntityName();
    if (Xrm.Page.getAttribute("cvt_relatedsiteid").getValue() != null) {
        MCS.cvt_MTSA_OnLoad.relatedProviderSiteName = Xrm.Page.getAttribute("cvt_relatedsiteid").getValue()[0].name;
        MCS.cvt_MTSA_OnLoad.relatedProviderSiteId = Xrm.Page.getAttribute("cvt_relatedsiteid").getValue()[0].id;
    }
    MCS.cvt_MTSA_OnLoad.GroupAppt = Xrm.Page.getAttribute("cvt_groupappointment").getValue();
};

MCS.cvt_MTSA_OnLoad.SOS = function () {
    //Make the SOS field visible and get the url
    if (Xrm.Page.getAttribute("cvt_servicetype").getValue() != null) {
        CrmRestKit.Retrieve('mcs_servicetype', Xrm.Page.getAttribute("cvt_servicetype").getValue()[0].id, ["cvt_specialtyoperationssupplement"], false).fail(function (err) {
            //alert("fail");
        }).done(function (data) {
            //alert("success");
            var url = data.d["cvt_specialtyoperationssupplement"];

            if (url) {
                Xrm.Page.getControl("cvt_specialtyoperationssupplement").setVisible(true);
                Xrm.Page.getAttribute("cvt_specialtyoperationssupplement").setValue(url);
            }
        });

    }
};